<?php
include_once '../baseInfo.php';
include_once '../config.php';

$now   = time();
$limit = 500;

// دیگر از OFFSET استفاده نمی‌کنیم
@unlink('warnOffset.txt');

/* -------------------- Helpers -------------------- */
function normalizeTs($ts) {
    if ($ts === null || $ts === '') return null;
    if (is_numeric($ts)) {
        $ts = (int)$ts;
        if ($ts > 2000000000) $ts = intdiv($ts, 1000); // ms->s
        return $ts > 0 ? $ts : null;
    }
    $t = strtotime((string)$ts);
    return $t ? $t : null;
}

// متن ساده و تمیز برای نمایش نام
function safeName($s) {
    $s = trim((string)$s);
    $s = preg_replace('/[\x00-\x1F\x7F]/u', '', $s);
    $s = preg_replace('/\s+/u', ' ', $s);
    return $s;
}

/* -------------------- LOOP 1: سفارش‌های موعددار (notif=0 یا notif<now) -------------------- */
$stmt = $connection->prepare("
    SELECT * FROM `orders_list`
    WHERE `status`=1 AND (`notif`=0 OR `notif` < ?)
    ORDER BY (notif = 0) DESC, CASE WHEN notif=0 THEN 0 ELSE notif END ASC, id ASC
    LIMIT ?
");
$stmt->bind_param("ii", $now, $limit);
$stmt->execute();
$orders = $stmt->get_result();
$stmt->close();

if ($orders && $orders->num_rows > 0) {
  while ($order = $orders->fetch_assoc()) {

    $orderId    = (int)$order['id'];
    $from_id    = $order['userid'];
    $remark     = $order['remark'] ?? '';
    $uuid       = $order['uuid'] ?? "0";
    $server_id  = (int)$order['server_id'];
    $inbound_id = (int)$order['inbound_id'];
    $notif      = (int)$order['notif'];

    // نام قابل نمایش
    $displayName = safeName($remark);
    $matchedEmail = '';

    // زمان انقضا از DB (هرکدام بود)
    $expiryFromDb = null;
    if (!empty($order['expire_date'])) $expiryFromDb = $order['expire_date'];   // INT
    if (!empty($order['expire_time'])) $expiryFromDb = $order['expire_time'];   // DATETIME
    $expiryDbSec = normalizeTs($expiryFromDb); // ممکن است null شود

    // پیش‌فرض‌ها (برای داده‌های پنل)
    $found=false; $logedIn=false;
    $total=null;  $up=0; $down=0; $enable=true; $expiryPanel=null;

    // نوع پنل
    $stmt = $connection->prepare("SELECT `type` FROM `server_config` WHERE `id`=?");
    $stmt->bind_param('i', $server_id);
    $stmt->execute();
    $tmp = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    $serverType = $tmp['type'] ?? '';

    if ($serverType === "marzban") {
        $info = getMarzbanUser($server_id, $remark);
        if (isset($info->username)) {
            $found   = true;
            $logedIn = true;
            $total   = isset($info->data_limit) ? (int)$info->data_limit : null; // bytes یا null
            $up      = isset($info->used_traffic) ? (int)$info->used_traffic : 0; // مصرف کل
            $expiryPanel = $info->expire ?? null; // ممکنه ms باشد
            $enable = (($info->status ?? '') === 'active');
            if ($displayName === '') $displayName = $info->username;
        } elseif (isset($info->detail) && $info->detail === "User not found") {
            $logedIn = true;
        }
    } else {
        // x-ui / sanaei
        $response = getJson($server_id);
        if ($response && $response->success) {
            $logedIn = true;
            $response = $response->obj;
            foreach ($response as $row) {
                if ($inbound_id == 0) {
                    $settingsObj = json_decode($row->settings ?? '{}');
                    $clients = (isset($settingsObj->clients) && is_array($settingsObj->clients)) ? $settingsObj->clients : [];
                    foreach ($clients as $c) {
                        $cid = $c->id ?? null;
                        $cpw = $c->password ?? null;
                        if (($cid && $cid == $uuid) || ($cpw && $cpw == $uuid)) {
                            $found = true;
                            $total = isset($row->total) ? (int)$row->total : null;
                            $up    = isset($row->up)   ? (int)$row->up   : 0;
                            $down  = isset($row->down) ? (int)$row->down : 0;
                            $expiryPanel = $row->expiryTime ?? null;
                            $enable = isset($row->enable) ? (bool)$row->enable : true;
                            $matchedEmail = safeName($c->email ?? '');
                            break 2;
                        }
                    }
                } else {
                    if ((int)$row->id === $inbound_id) {
                        $settings = json_decode($row->settings ?? '[]', true);
                        $clients  = $settings['clients'] ?? [];
                        $clientsStates = $row->clientStats ?? [];
                        $statesByEmail = [];
                        foreach ($clientsStates as $st) { $statesByEmail[$st->email ?? ''] = $st; }
                        foreach ($clients as $client) {
                            $cid = $client['id'] ?? null;
                            $cpw = $client['password'] ?? null;
                            if (($cid && $cid == $uuid) || ($cpw && $cpw == $uuid)) {
                                $found = true;
                                $email = $client['email'] ?? '';
                                $st    = $statesByEmail[$email] ?? null;
                                $total = isset($client['totalGB']) ? (int)$client['totalGB'] : null;
                                $up    = isset($st->up)    ? (int)$st->up    : 0;
                                $down  = isset($st->down)  ? (int)$st->down  : 0;
                                $enable= isset($st->enable)? (bool)$st->enable: true;
                                $expiryPanel = $st->expiryTime ?? null;
                                $matchedEmail = safeName($email);
                                break 2;
                            }
                        }
                    }
                }
            }
        }
    }

    // تعیین نام قابل نمایش
    if ($displayName === '') $displayName = $matchedEmail;
    if ($displayName === '' && !empty($uuid)) $displayName = $uuid;
    $displayName = safeName($displayName);

    // جمع‌بندی زمان: اولویت با پنل؛ اگر نبود از DB
    $expiryAnySec = normalizeTs($expiryPanel);
    if ($expiryAnySec === null) $expiryAnySec = $expiryDbSec;

    // اگر پنل پیدا شد، محاسبه حجم
    $leftgb = null;
    if ($found && $total !== null) {
        $used = (int)$up + (int)$down;
        $totalLeft = max(0, (int)$total - $used);
        $leftgb = round($totalLeft / 1073741824, 2);
    }

    /* -------- اعلان فوری: پایان/غیرفعال/زمان گذشته --------
       نکته: این بخش حتی اگر $found=false باشد، ولی expireAnySec از DB داشته باشیم، کار می‌کند. */
    $shouldEndNow = false;
    if ($notif == 0) {
        if ($leftgb !== null && $leftgb <= 0) $shouldEndNow = true;           // بر مبنای پنل
        if ($expiryAnySec !== null && $expiryAnySec <= $now) $shouldEndNow = true; // بر مبنای زمان (پنل یا DB)
        if ($found && !$enable) $shouldEndNow = true;                          // فقط اگر پنل را یافت
    }

    if ($shouldEndNow) {
        $newTime = $now + 2*86400;
        $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `id`=? AND `notif`=0");
        $stmt->bind_param("ii", $newTime, $orderId);
        $stmt->execute();
        $rows = $stmt->affected_rows;
        $stmt->close();

        if ($rows > 0) {
            $msg = "💡 کاربر گرامی،
اشتراک «{$displayName}» به پایان رسیده/غیرفعال شده است. می‌توانید از «خریدهای من» تمدید کنید یا سرویس جدید بخرید.";
            sendMessage($msg, null, null, $from_id);
        }
        continue;
    }

    /* -------- هشدار نزدیک انقضا (<24h) یا (اگر پنل پیدا شد) کمتر از 1GB -------- */
    if ($notif == 0) {
        $shouldWarnTime = ($expiryAnySec !== null && $expiryAnySec < $now + 86400);
        $shouldWarnData = ($leftgb !== null && $leftgb < 1); // فقط اگر پنل داده حجمی دارد

        if ($shouldWarnTime || $shouldWarnData) {
            $nextCheck = $now + 3600;
            if ($expiryAnySec !== null) $nextCheck = min($nextCheck, $expiryAnySec);

            $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `id`=? AND `notif`=0");
            $stmt->bind_param("ii", $nextCheck, $orderId);
            $stmt->execute();
            $rows = $stmt->affected_rows;
            $stmt->close();

            if ($rows > 0) {
                $unit = $shouldWarnTime ? "روز" : "گیگ";
                $msg = "💡 کاربر گرامی،
از سرویس اشتراک «{$displayName}» تنها (۱ {$unit}) باقی مانده است. می‌توانید از «خریدهای من» تمدید کنید یا سرویس جدید خریداری کنید.";
                sendMessage($msg, null, null, $from_id);
            }
            continue;
        }
    }

    // اگر تنها نشانه‌ای از disable از پنل داریم ولی قبلاً notif ست نشده
    if ($found && !$enable && $notif <= 0) {
        $newTime = $now + 2*86400;
        $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `id`=? AND `notif`<=0");
        $stmt->bind_param("ii", $newTime, $orderId);
        $stmt->execute();
        $stmt->close();
        continue;
    }
  }
}

/* -------------------- LOOP 2: حذف نهایی پس از موعد (notif>0 && notif<now) -------------------- */
$stmt = $connection->prepare("
    SELECT * FROM `orders_list`
    WHERE `status`=1 AND `notif` > 0 AND `notif` < ?
    LIMIT 200
");
$stmt->bind_param("i", $now);
$stmt->execute();
$orders = $stmt->get_result();
$stmt->close();

if ($orders && $orders->num_rows > 0) {
  while ($order = $orders->fetch_assoc()) {
    $orderId   = (int)$order['id'];
    $from_id   = $order['userid'];
    $uuid      = $order['uuid'] ?? "0";
    $server_id = (int)$order['server_id'];
    $inbound_id= (int)$order['inbound_id'];

    $displayName = safeName($order['remark'] ?? '');
    if ($displayName === '' && !empty($uuid)) $displayName = $uuid;

    $stmt = $connection->prepare("SELECT `type` FROM `server_config` WHERE `id`=?");
    $stmt->bind_param('i', $server_id);
    $stmt->execute();
    $rowConf = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    $serverType = $rowConf['type'] ?? '';

    if ($serverType === "marzban") {
        $res = deleteMarzban($server_id, $order['remark'] ?? '');
    } else {
        if ($inbound_id > 0) $res = deleteClient($server_id, $inbound_id, $uuid, 1);
        else $res = deleteInbound($server_id, $uuid, 1);
    }

    if (!is_null($res)) {
        $msg = "💡 کاربر گرامی،
اشتراک «{$displayName}» منقضی شد و از لیست سفارش‌ها حذف گردید. لطفاً از فروشگاه سرویس جدید خریداری کنید.";
        sendMessage($msg, null, null, $from_id);

        $stmt = $connection->prepare("DELETE FROM `orders_list` WHERE `uuid`=?");
        $stmt->bind_param("s", $uuid);
        $stmt->execute();
        $stmt->close();
    } else {
        $retry = $now + 6*3600;
        $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `id`=?");
        $stmt->bind_param("ii", $retry, $orderId);
        $stmt->execute();
        $stmt->close();
    }
  }
}
